# 🔧 Panduan Perbaikan Midtrans Payment

## ❌ Error yang Terjadi

```
Midtrans API is returning API error. HTTP status code: 401
Access denied due to unauthorized transaction, please check client or server key
```

## ✅ Solusi

### 1. Update Konfigurasi di `.env`

Buka file `.env` di root project dan **tambahkan atau update** baris berikut:

```bash
# ==========================================
# MIDTRANS CONFIGURATION (SANDBOX)
# ==========================================
MIDTRANS_MERCHANT_ID=G528400634
MIDTRANS_CLIENT_KEY=SB-Mid-client-wWtaH_iM-JTP4BNI
MIDTRANS_SERVER_KEY=SB-Mid-server-l1yAaWY7IVxOmjRC93NMKCzy
MIDTRANS_IS_PRODUCTION=false
MIDTRANS_IS_SANITIZED=true
MIDTRANS_IS_3DS=true
```

### 2. Clear Cache Laravel

Setelah update `.env`, jalankan command berikut:

```bash
php artisan config:clear
php artisan cache:clear
```

### 3. Restart Server (jika menggunakan php artisan serve)

```bash
# Tekan CTRL+C untuk stop server
# Kemudian jalankan lagi:
php artisan serve
```

### 4. Test Pembayaran

1. Buat order baru
2. Pilih metode pembayaran QRIS
3. QR Code seharusnya muncul
4. Untuk testing di sandbox, gunakan Midtrans Simulator

## 📱 Testing di Sandbox Midtrans

### Cara Test QRIS di Sandbox:

1. **Akses Simulator**: https://simulator.sandbox.midtrans.com/
2. **Atau gunakan Midtrans Test App** (jika ada)
3. **QR Code** yang muncul adalah QR sandbox, tidak bisa di-scan dengan e-wallet real
4. Untuk simulasi success:
   - Buka Midtrans Dashboard Sandbox
   - Cari transaksi berdasarkan Order ID
   - Klik "Mark as Paid" atau gunakan simulator

### Cara Manual Test (via Dashboard):

1. Login ke: https://dashboard.sandbox.midtrans.com/
2. Masuk dengan akun merchant Anda
3. Cari transaksi di menu "Transactions"
4. Klik transaksi yang ingin di-test
5. Klik tombol **"Mark as Paid"** atau **"Update Status"**
6. Sistem akan otomatis kirim notification ke webhook

## 🔍 Verifikasi Konfigurasi

Cek apakah konfigurasi sudah benar dengan command:

```bash
php artisan tinker
```

Kemudian jalankan:

```php
config('midtrans.server_key');
config('midtrans.client_key');
config('midtrans.merchant_id');
config('midtrans.is_production');
```

Output seharusnya menunjukkan nilai yang benar (bukan empty string).

## 🌐 Webhook Notification URL

Pastikan webhook URL di Midtrans Dashboard sudah diset:

**URL**: `https://your-domain.com/api/midtrans/notification`

Untuk development lokal, gunakan **ngrok** atau **expose**:

```bash
# Install ngrok
npm install -g ngrok

# Expose local server
ngrok http 8000

# Copy URL https dan update di Midtrans Dashboard
```

## 📝 Catatan Penting

### Sandbox vs Production

- **Sandbox**: Untuk testing (URL: `api.sandbox.midtrans.com`)
- **Production**: Untuk live (URL: `api.midtrans.com`)
- Set `MIDTRANS_IS_PRODUCTION=false` untuk sandbox
- Set `MIDTRANS_IS_PRODUCTION=true` untuk production

### Security

⚠️ **JANGAN** commit file `.env` ke Git!
⚠️ **JANGAN** share Server Key ke public!

### Troubleshooting

| Error | Solusi |
|-------|--------|
| 401 Unauthorized | Check Server Key di `.env` |
| QR Code tidak muncul | Check Client Key & connection |
| Notification tidak masuk | Check Webhook URL di Dashboard |
| Transaction not found | Check Merchant ID & environment (sandbox/prod) |

## 🎯 Next Steps

Setelah konfigurasi benar:

1. ✅ Clear cache (sudah dilakukan)
2. ✅ Update `.env` dengan keys yang benar
3. 🔄 Restart server
4. 🧪 Test payment flow
5. 📧 Setup email notification (optional)

---

**Dokumentasi Lengkap**: https://docs.midtrans.com/
**Simulator**: https://simulator.sandbox.midtrans.com/
**Dashboard Sandbox**: https://dashboard.sandbox.midtrans.com/
