@extends('layouts.app')

@section('title', 'Buat Reservasi Baru')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Buat Reservasi Baru</h4>
                    <a href="{{ route('reservations.index') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="ri-arrow-left-line me-1"></i>Kembali
                    </a>
                </div>
                <div class="card-body">
                    <form action="{{ route('reservations.store') }}" method="POST">
                        @csrf

                        {{-- Outlet Selection --}}
                        <div class="mb-3">
                            <label for="outlet_id" class="form-label">Outlet <span class="text-danger">*</span></label>
                            <select name="outlet_id" id="outlet_id" class="form-select @error('outlet_id') is-invalid @enderror" required>
                                <option value="">Pilih Outlet</option>
                                @foreach($outlets as $outlet)
                                <option value="{{ $outlet->id }}" {{ old('outlet_id') == $outlet->id ? 'selected' : '' }}>
                                    {{ $outlet->name }}
                                </option>
                                @endforeach
                            </select>
                            @error('outlet_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Table Selection --}}
                        <div class="mb-3">
                            <label for="table_id" class="form-label">Meja <small class="text-muted">(Opsional - bisa ditentukan nanti)</small></label>
                            <select name="table_id" id="table_id" class="form-select @error('table_id') is-invalid @enderror">
                                <option value="">Belum ditentukan</option>
                                @foreach($tables as $table)
                                <option value="{{ $table->id }}" {{ old('table_id') == $table->id ? 'selected' : '' }}>
                                    Meja {{ $table->table_number }} (Kapasitas: {{ $table->capacity ?? 'N/A' }})
                                </option>
                                @endforeach
                            </select>
                            @error('table_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Date & Time --}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="reservation_date" class="form-label">Tanggal <span class="text-danger">*</span></label>
                                <input type="date" name="reservation_date" id="reservation_date" 
                                       class="form-control @error('reservation_date') is-invalid @enderror" 
                                       value="{{ old('reservation_date', date('Y-m-d')) }}" 
                                       min="{{ date('Y-m-d') }}" 
                                       required>
                                @error('reservation_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="reservation_time" class="form-label">Waktu <span class="text-danger">*</span></label>
                                <input type="time" name="reservation_time" id="reservation_time" 
                                       class="form-control @error('reservation_time') is-invalid @enderror" 
                                       value="{{ old('reservation_time') }}" 
                                       required>
                                @error('reservation_time')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        {{-- Party Size --}}
                        <div class="mb-3">
                            <label for="party_size" class="form-label">Jumlah Orang <span class="text-danger">*</span></label>
                            <input type="number" name="party_size" id="party_size" 
                                   class="form-control @error('party_size') is-invalid @enderror" 
                                   value="{{ old('party_size', 2) }}" 
                                   min="1" max="20" required>
                            @error('party_size')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3">Informasi Customer</h5>

                        {{-- Guest Name --}}
                        <div class="mb-3">
                            <label for="guest_name" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" name="guest_name" id="guest_name" 
                                   class="form-control @error('guest_name') is-invalid @enderror" 
                                   value="{{ old('guest_name') }}" 
                                   placeholder="Masukkan nama lengkap" required>
                            @error('guest_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Guest Email --}}
                        <div class="mb-3">
                            <label for="guest_email" class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" name="guest_email" id="guest_email" 
                                   class="form-control @error('guest_email') is-invalid @enderror" 
                                   value="{{ old('guest_email') }}" 
                                   placeholder="customer@email.com" required>
                            @error('guest_email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Guest Phone --}}
                        <div class="mb-3">
                            <label for="guest_phone" class="form-label">No. Telepon <span class="text-danger">*</span></label>
                            <input type="text" name="guest_phone" id="guest_phone" 
                                   class="form-control @error('guest_phone') is-invalid @enderror" 
                                   value="{{ old('guest_phone') }}" 
                                   placeholder="08123456789" required>
                            @error('guest_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Special Requests --}}
                        <div class="mb-3">
                            <label for="special_requests" class="form-label">Permintaan Khusus</label>
                            <textarea name="special_requests" id="special_requests" 
                                      class="form-control @error('special_requests') is-invalid @enderror" 
                                      rows="3" placeholder="Contoh: Dekat jendela, high chair untuk anak, dll.">{{ old('special_requests') }}</textarea>
                            @error('special_requests')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Internal Notes --}}
                        <div class="mb-3">
                            <label for="notes" class="form-label">Catatan Internal <small class="text-muted">(Tidak dilihat customer)</small></label>
                            <textarea name="notes" id="notes" 
                                      class="form-control @error('notes') is-invalid @enderror" 
                                      rows="2" placeholder="Catatan untuk staf/kasir...">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <a href="{{ route('reservations.index') }}" class="btn btn-secondary">
                                Batal
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-save-line me-1"></i>Simpan Reservasi
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
