@extends('layouts.app')

@section('title', 'Edit Reservasi - ' . $reservation->reservation_number)

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Edit Reservasi</h4>
                    <a href="{{ route('reservations.show', $reservation) }}" class="btn btn-outline-secondary btn-sm">
                        <i class="ri-arrow-left-line me-1"></i>Kembali
                    </a>
                </div>
                <div class="card-body">
                    {{-- Info Banner --}}
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="ri-information-line me-2"></i>
                        <strong>No. Reservasi: {{ $reservation->reservation_number }}</strong>
                        <br>
                        <small>Dibuat pada: {{ $reservation->created_at->format('d F Y H:i') }}</small>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>

                    <form action="{{ route('reservations.update', $reservation) }}" method="POST">
                        @csrf
                        @method('PUT')

                        {{-- Outlet Selection --}}
                        <div class="mb-3">
                            <label for="outlet_id" class="form-label">Outlet <span class="text-danger">*</span></label>
                            <select name="outlet_id" id="outlet_id" class="form-select @error('outlet_id') is-invalid @enderror" required>
                                <option value="">Pilih Outlet</option>
                                @foreach($outlets as $outlet)
                                <option value="{{ $outlet->id }}" {{ (old('outlet_id', $reservation->outlet_id) == $outlet->id) ? 'selected' : '' }}>
                                    {{ $outlet->name }}
                                </option>
                                @endforeach
                            </select>
                            @error('outlet_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Table Selection --}}
                        <div class="mb-3">
                            <label for="table_id" class="form-label">Meja <small class="text-muted">(Opsional)</small></label>
                            <select name="table_id" id="table_id" class="form-select @error('table_id') is-invalid @enderror">
                                <option value="">Belum ditentukan</option>
                                @foreach($tables as $table)
                                <option value="{{ $table->id }}" {{ (old('table_id', $reservation->table_id) == $table->id) ? 'selected' : '' }}>
                                    Meja {{ $table->table_number }}
                                    (Kapasitas: {{ $table->capacity ?? 'N/A' }})
                                    @if($table->status !== 'available')
                                        - {{ ucfirst($table->status) }}
                                    @endif
                                </option>
                                @endforeach
                            </select>
                            @error('table_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Date & Time --}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="reservation_date" class="form-label">Tanggal <span class="text-danger">*</span></label>
                                <input type="date" name="reservation_date" id="reservation_date"
                                       class="form-control @error('reservation_date') is-invalid @enderror"
                                       value="{{ old('reservation_date', $reservation->reservation_date->format('Y-m-d')) }}"
                                       required>
                                @error('reservation_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="reservation_time" class="form-label">Waktu <span class="text-danger">*</span></label>
                                <input type="time" name="reservation_time" id="reservation_time"
                                       class="form-control @error('reservation_time') is-invalid @enderror"
                                       value="{{ old('reservation_time', $reservation->reservation_time->format('H:i')) }}"
                                       required>
                                @error('reservation_time')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        {{-- Party Size --}}
                        <div class="mb-3">
                            <label for="party_size" class="form-label">Jumlah Orang <span class="text-danger">*</span></label>
                            <input type="number" name="party_size" id="party_size"
                                   class="form-control @error('party_size') is-invalid @enderror"
                                   value="{{ old('party_size', $reservation->party_size) }}"
                                   min="1" max="20" required>
                            @error('party_size')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Status --}}
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-select @error('status') is-invalid @enderror" required>
                                @foreach(\App\Models\Reservation::getStatuses() as $value => $label)
                                <option value="{{ $value }}" {{ (old('status', $reservation->status) == $value) ? 'selected' : '' }}>
                                    {{ $label }}
                                </option>
                                @endforeach
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">
                                Status saat ini:
                                <span class="badge bg-label-{{
                                    $reservation->status === 'confirmed' ? 'success' :
                                    ($reservation->status === 'pending' ? 'warning' :
                                    ($reservation->status === 'completed' ? 'info' :
                                    ($reservation->status === 'cancelled' ? 'danger' : 'secondary')))
                                }}">
                                    {{ \App\Models\Reservation::getStatuses()[$reservation->status] }}
                                </span>
                            </small>
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3">Informasi Customer</h5>

                        {{-- Customer Info Display (Read-only) --}}
                        <div class="alert alert-light">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Nama:</strong><br>
                                    {{ $reservation->customer_name }}
                                </div>
                                <div class="col-md-4">
                                    <strong>Email:</strong><br>
                                    {{ $reservation->customer_email }}
                                </div>
                                <div class="col-md-4">
                                    <strong>No. Telepon:</strong><br>
                                    {{ $reservation->customer_phone }}
                                </div>
                            </div>
                            <small class="text-muted d-block mt-2">
                                <i class="ri-information-line me-1"></i>
                                Informasi customer tidak dapat diubah. Untuk mengubah, hubungi customer dan buat reservasi baru.
                            </small>
                        </div>

                        {{-- Special Requests --}}
                        <div class="mb-3">
                            <label for="special_requests" class="form-label">Permintaan Khusus</label>
                            <textarea name="special_requests" id="special_requests"
                                      class="form-control @error('special_requests') is-invalid @enderror"
                                      rows="3" placeholder="Contoh: Dekat jendela, high chair untuk anak, dll.">{{ old('special_requests', $reservation->special_requests) }}</textarea>
                            @error('special_requests')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Internal Notes --}}
                        <div class="mb-3">
                            <label for="notes" class="form-label">Catatan Internal <small class="text-muted">(Tidak dilihat customer)</small></label>
                            <textarea name="notes" id="notes"
                                      class="form-control @error('notes') is-invalid @enderror"
                                      rows="2" placeholder="Catatan untuk staf/kasir...">{{ old('notes', $reservation->notes) }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Action Buttons --}}
                        <div class="d-grid gap-2 d-md-flex justify-content-md-between mt-4">
                            <div>
                                <a href="{{ route('reservations.show', $reservation) }}" class="btn btn-secondary">
                                    <i class="ri-arrow-left-line me-1"></i>Batal
                                </a>
                            </div>
                            <div class="d-flex gap-2">
                                @if($reservation->canBeCancelled())
                                <button type="button" class="btn btn-danger" onclick="confirmDelete()">
                                    <i class="ri-close-circle-line me-1"></i>Batalkan Reservasi
                                </button>
                                @endif
                                <button type="submit" class="btn btn-primary">
                                    <i class="ri-save-line me-1"></i>Simpan Perubahan
                                </button>
                            </div>
                        </div>
                    </form>

                    {{-- Hidden Delete Form --}}
                    @if($reservation->canBeCancelled())
                    <form id="deleteForm" action="{{ route('reservations.destroy', $reservation) }}" method="POST" class="d-none">
                        @csrf
                        @method('DELETE')
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmDelete() {
        Swal.fire({
            title: 'Batalkan Reservasi?',
            text: 'Apakah Anda yakin ingin membatalkan reservasi ini? Tindakan ini tidak dapat dibatalkan.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Ya, Batalkan!',
            cancelButtonText: 'Tidak'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteForm').submit();
            }
        });
    }

    @if(session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}'
        });
    @endif

    // Auto-update date minimum to today
    document.addEventListener('DOMContentLoaded', function() {
        const dateInput = document.getElementById('reservation_date');
        const currentStatus = '{{ $reservation->status }}';

        // If reservation is not pending or confirmed, don't allow past dates
        if (['completed', 'cancelled', 'no_show'].includes(currentStatus)) {
            // Allow any date for historical records
            dateInput.removeAttribute('min');
        }
    });
</script>
@endpush
