@extends('layouts.app')

@section('title', 'Manajemen Reservasi')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Manajemen Reservasi</h4>
                    <a href="{{ route('reservations.create') }}" class="btn btn-primary">
                        <i class="ri-add-line me-1"></i>Buat Reservasi Baru
                    </a>
                </div>
                <div class="card-body">
                    {{-- Statistics Cards --}}
                    <div class="row mb-4">
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Total Reservasi</h6>
                                    <h3 class="mb-0">{{ number_format($stats['total_reservations']) }}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-warning text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Menunggu Konfirmasi</h6>
                                    <h3 class="mb-0">{{ number_format($stats['pending_reservations']) }}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Dikonfirmasi</h6>
                                    <h3 class="mb-0">{{ number_format($stats['confirmed_reservations']) }}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Hari Ini</h6>
                                    <h3 class="mb-0">{{ number_format($stats['today_reservations']) }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Filters --}}
                    <form method="GET" class="row g-3 mb-4">
                        <div class="col-md-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="">Semua Status</option>
                                @foreach($statuses as $value => $label)
                                <option value="{{ $value }}" {{ request('status') == $value ? 'selected' : '' }}>
                                    {{ $label }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Outlet</label>
                            <select name="outlet_id" class="form-select">
                                <option value="">Semua Outlet</option>
                                @foreach($outlets as $outlet)
                                <option value="{{ $outlet->id }}" {{ request('outlet_id') == $outlet->id ? 'selected' : '' }}>
                                    {{ $outlet->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Tanggal</label>
                            <input type="date" name="date" class="form-control" value="{{ request('date') }}">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" class="btn btn-primary d-block w-100">
                                <i class="ri-search-line me-1"></i>Filter
                            </button>
                        </div>
                    </form>

                    {{-- Reservations Table --}}
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No. Reservasi</th>
                                    <th>Customer</th>
                                    <th>Outlet</th>
                                    <th>Meja</th>
                                    <th>Tanggal & Waktu</th>
                                    <th>Jumlah Orang</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reservations as $reservation)
                                <tr>
                                    <td><strong>{{ $reservation->reservation_number }}</strong></td>
                                    <td>
                                        {{ $reservation->customer_name }}
                                        <br><small class="text-muted">{{ $reservation->customer_email }}</small>
                                    </td>
                                    <td>{{ $reservation->outlet->name }}</td>
                                    <td>
                                        @if($reservation->table)
                                            <span class="badge bg-label-info">{{ $reservation->table->table_number }}</span>
                                        @else
                                            <span class="badge bg-label-secondary">Belum ditentukan</span>
                                        @endif
                                    </td>
                                    <td>{{ $reservation->formatted_date_time }}</td>
                                    <td>{{ $reservation->party_size }} orang</td>
                                    <td>
                                        <span class="badge bg-label-{{
                                            $reservation->status === 'confirmed' ? 'success' :
                                            ($reservation->status === 'pending' ? 'warning' :
                                            ($reservation->status === 'completed' ? 'info' :
                                            ($reservation->status === 'cancelled' ? 'danger' : 'secondary')))
                                        }}">
                                            {{ $statuses[$reservation->status] }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('reservations.show', $reservation) }}" class="btn btn-sm btn-info">
                                            <i class="ri-eye-line"></i>
                                        </a>
                                        <a href="{{ route('reservations.edit', $reservation) }}" class="btn btn-sm btn-warning">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="ri-calendar-line ri-3x text-muted"></i>
                                        <p class="text-muted mt-2">Tidak ada reservasi ditemukan.</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- Pagination --}}
                    <div class="mt-3">
                        {{ $reservations->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            timer: 3000
        });
    @endif
</script>
@endpush
