@extends('layouts.app')

@section('title', 'Detail Reservasi - ' . $reservation->reservation_number)

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Detail Reservasi</h4>
                    <a href="{{ route('reservations.index') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="ri-arrow-left-line me-1"></i>Kembali
                    </a>
                </div>
                <div class="card-body">
                    {{-- Reservation Info --}}
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6 class="fw-bold">Informasi Reservasi</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="150">No. Reservasi:</td>
                                    <td><strong class="text-primary">{{ $reservation->reservation_number }}</strong></td>
                                </tr>
                                <tr>
                                    <td>Status:</td>
                                    <td>
                                        <span class="badge bg-label-{{
                                            $reservation->status === 'confirmed' ? 'success' :
                                            ($reservation->status === 'pending' ? 'warning' :
                                            ($reservation->status === 'completed' ? 'info' :
                                            ($reservation->status === 'cancelled' ? 'danger' : 'secondary')))
                                        }}">
                                            {{ \App\Models\Reservation::getStatuses()[$reservation->status] }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Tanggal:</td>
                                    <td>{{ $reservation->reservation_date->format('d F Y') }}</td>
                                </tr>
                                <tr>
                                    <td>Waktu:</td>
                                    <td>{{ $reservation->reservation_time->format('H:i') }} WIB</td>
                                </tr>
                                <tr>
                                    <td>Jumlah Orang:</td>
                                    <td><strong>{{ $reservation->party_size }} orang</strong></td>
                                </tr>
                                <tr>
                                    <td>Outlet:</td>
                                    <td>{{ $reservation->outlet->name }}</td>
                                </tr>
                                <tr>
                                    <td>Meja:</td>
                                    <td>
                                        @if($reservation->table)
                                            <span class="badge bg-label-info">{{ $reservation->table->table_number }}</span>
                                            <small class="text-muted">(Kapasitas: {{ $reservation->table->capacity ?? 'N/A' }})</small>
                                        @else
                                            <span class="badge bg-label-secondary">Belum ditentukan</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold">Informasi Customer</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="120">Nama:</td>
                                    <td>
                                        <strong>{{ $reservation->customer_name }}</strong>
                                        @if($reservation->user)
                                            <span class="badge bg-label-success ms-2">
                                                <i class="ri-user-line"></i> Registered User
                                            </span>
                                        @else
                                            <span class="badge bg-label-secondary ms-2">
                                                <i class="ri-user-line"></i> Guest
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>Email:</td>
                                    <td>
                                        {{ $reservation->customer_email ?? '-' }}
                                        @if($reservation->customer_email)
                                            <a href="mailto:{{ $reservation->customer_email }}" class="btn btn-sm btn-link p-0 ms-2">
                                                <i class="ri-mail-line"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>No. Telepon:</td>
                                    <td>
                                        {{ $reservation->customer_phone ?? '-' }}
                                        @if($reservation->customer_phone)
                                            <a href="tel:{{ $reservation->customer_phone }}" class="btn btn-sm btn-link p-0 ms-2">
                                                <i class="ri-phone-line"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>Dibuat pada:</td>
                                    <td>{{ $reservation->created_at->format('d F Y H:i') }}</td>
                                </tr>
                                @if($reservation->confirmed_at)
                                <tr>
                                    <td>Dikonfirmasi:</td>
                                    <td>{{ $reservation->confirmed_at->format('d F Y H:i') }}</td>
                                </tr>
                                @endif
                                @if($reservation->cancelled_at)
                                <tr>
                                    <td>Dibatalkan:</td>
                                    <td>{{ $reservation->cancelled_at->format('d F Y H:i') }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>

                    {{-- Special Requests --}}
                    @if($reservation->special_requests)
                    <div class="mb-4">
                        <h6 class="fw-bold">Permintaan Khusus</h6>
                        <div class="alert alert-info">
                            <i class="ri-information-line me-2"></i>
                            {{ $reservation->special_requests }}
                        </div>
                    </div>
                    @endif

                    {{-- Internal Notes --}}
                    @if($reservation->notes)
                    <div class="mb-4">
                        <h6 class="fw-bold">Catatan Internal</h6>
                        <div class="alert alert-warning">
                            <i class="ri-file-text-line me-2"></i>
                            {{ $reservation->notes }}
                        </div>
                    </div>
                    @endif

                    {{-- Action Buttons --}}
                    <div class="d-flex gap-2">
                        <a href="{{ route('reservations.edit', $reservation) }}" class="btn btn-warning">
                            <i class="ri-edit-line me-1"></i>Edit Reservasi
                        </a>

                        @if($reservation->canBeCancelled())
                        <form action="{{ route('reservations.destroy', $reservation) }}" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin membatalkan reservasi ini?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <i class="ri-close-circle-line me-1"></i>Batalkan Reservasi
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        {{-- Quick Actions Sidebar --}}
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <form id="statusForm">
                        <div class="mb-3">
                            <label class="form-label">Ubah Status</label>
                            <select name="status" class="form-select" id="statusSelect">
                                @foreach(\App\Models\Reservation::getStatuses() as $value => $label)
                                <option value="{{ $value }}" {{ $reservation->status === $value ? 'selected' : '' }}>
                                    {{ $label }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="ri-refresh-line me-1"></i>Update Status
                        </button>
                    </form>

                    <hr class="my-3">

                    <div class="d-grid gap-2">
                        <a href="mailto:{{ $reservation->customer_email }}" class="btn btn-outline-primary btn-sm">
                            <i class="ri-mail-line me-1"></i>Email Customer
                        </a>
                        <a href="tel:{{ $reservation->customer_phone }}" class="btn btn-outline-success btn-sm">
                            <i class="ri-phone-line me-1"></i>Hubungi Customer
                        </a>
                    </div>
                </div>
            </div>

            {{-- Reservation Timeline --}}
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0">Timeline</h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Reservasi Dibuat</h6>
                                <p class="text-muted mb-0">{{ $reservation->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>

                        @if($reservation->confirmed_at)
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Dikonfirmasi</h6>
                                <p class="text-muted mb-0">{{ $reservation->confirmed_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                        @endif

                        @if($reservation->status === 'completed')
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Selesai</h6>
                                <p class="text-muted mb-0">Customer hadir dan selesai</p>
                            </div>
                        </div>
                        @endif

                        @if($reservation->cancelled_at)
                        <div class="timeline-item">
                            <div class="timeline-marker bg-danger"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Dibatalkan</h6>
                                <p class="text-muted mb-0">{{ $reservation->cancelled_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            timer: 3000
        });
    @endif

    // Update Status
    const statusForm = document.getElementById('statusForm');
    statusForm.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        const newStatus = formData.get('status');
        const currentStatus = "{{ $reservation->status }}";

        if (newStatus === currentStatus) {
            Swal.fire('Info', 'Status tidak berubah.', 'info');
            return;
        }

        Swal.fire({
            title: 'Konfirmasi',
            text: 'Apakah Anda yakin ingin mengubah status reservasi?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ya, Ubah',
            cancelButtonText: 'Batal',
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`/console/reservations/{{ $reservation->id }}/status`, {
                    method: 'PATCH',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({ status: newStatus })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire('Berhasil', 'Status reservasi berhasil diubah.', 'success').then(() => location.reload());
                    } else {
                        Swal.fire('Gagal', 'Gagal mengubah status reservasi.', 'error');
                    }
                })
                .catch(() => Swal.fire('Gagal', 'Terjadi kesalahan saat mengubah status.', 'error'));
            }
        });
    });
</script>

<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -35px;
    top: 0;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid #fff;
    box-shadow: 0 0 0 2px #e9ecef;
}

.timeline-item:not(:last-child)::after {
    content: '';
    position: absolute;
    left: -29px;
    top: 12px;
    width: 2px;
    height: calc(100% + 8px);
    background-color: #e9ecef;
}

.timeline-content h6 {
    margin-bottom: 5px;
    font-size: 14px;
}

.timeline-content p {
    font-size: 12px;
}
</style>
@endpush
