@extends('layouts.guest-order')

@section('title', 'Reservasi Meja')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            {{-- Header --}}
            <div class="text-center mb-5">
                <h2 class="fw-bold">🍽️ Reservasi Meja</h2>
                <p class="text-muted">Pesan meja Anda sekarang dan nikmati pengalaman dining yang lebih nyaman</p>
            </div>

            {{-- Error/Success Messages --}}
            @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ri-error-warning-line me-2"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif

            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ri-check-line me-2"></i>
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif

            {{-- Booking Form --}}
            <div class="card shadow-sm">
                <div class="card-body p-4">
                    <form action="{{ route('customer.reservations.store') }}" method="POST" id="reservationForm">
                        @csrf

                        {{-- Outlet Selection --}}
                        <div class="mb-4">
                            <label for="outlet_id" class="form-label fw-bold">
                                <i class="ri-store-line me-1"></i>Pilih Outlet <span class="text-danger">*</span>
                            </label>
                            <select name="outlet_id" id="outlet_id" class="form-select @error('outlet_id') is-invalid @enderror" required>
                                <option value="">-- Pilih Outlet --</option>
                                @foreach($outlets as $outlet)
                                <option value="{{ $outlet->id }}" {{ old('outlet_id') == $outlet->id ? 'selected' : '' }}>
                                    {{ $outlet->name }}
                                </option>
                                @endforeach
                            </select>
                            @error('outlet_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Date & Time --}}
                        <div class="row mb-4">
                            <div class="col-md-6 mb-3 mb-md-0">
                                <label for="reservation_date" class="form-label fw-bold">
                                    <i class="ri-calendar-line me-1"></i>Tanggal <span class="text-danger">*</span>
                                </label>
                                <input type="date" name="reservation_date" id="reservation_date"
                                       class="form-control @error('reservation_date') is-invalid @enderror"
                                       value="{{ old('reservation_date', date('Y-m-d')) }}"
                                       min="{{ date('Y-m-d') }}"
                                       max="{{ date('Y-m-d', strtotime('+30 days')) }}"
                                       required>
                                <small class="text-muted">Reservasi maksimal 30 hari ke depan</small>
                                @error('reservation_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="reservation_time" class="form-label fw-bold">
                                    <i class="ri-time-line me-1"></i>Waktu <span class="text-danger">*</span>
                                </label>
                                <select name="reservation_time" id="reservation_time"
                                        class="form-select @error('reservation_time') is-invalid @enderror" required>
                                    <option value="">-- Pilih Waktu --</option>
                                    @foreach($timeSlots as $slot)
                                    <option value="{{ $slot }}" {{ old('reservation_time') == $slot ? 'selected' : '' }}>
                                        {{ $slot }} WIB
                                    </option>
                                    @endforeach
                                </select>
                                <small class="text-muted">Jam operasional: 10:00 - 22:00</small>
                                @error('reservation_time')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        {{-- Party Size --}}
                        <div class="mb-4">
                            <label for="party_size" class="form-label fw-bold">
                                <i class="ri-group-line me-1"></i>Jumlah Orang <span class="text-danger">*</span>
                            </label>
                            <input type="number" name="party_size" id="party_size"
                                   class="form-control @error('party_size') is-invalid @enderror"
                                   value="{{ old('party_size', 2) }}"
                                   min="1" max="20" required>
                            <small class="text-muted">Maksimal 20 orang per reservasi</small>
                            @error('party_size')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <hr class="my-4">

                        {{-- Guest Info (if not logged in) --}}
                        @guest
                        <h5 class="mb-3"><i class="ri-user-line me-2"></i>Informasi Kontak</h5>
                        <div class="alert alert-info">
                            <i class="ri-information-line me-2"></i>
                            <small>Anda tidak perlu login untuk melakukan reservasi. Cukup isi informasi di bawah ini.</small>
                        </div>

                        <div class="mb-3">
                            <label for="guest_name" class="form-label">
                                Nama Lengkap <span class="text-danger">*</span>
                            </label>
                            <input type="text" name="guest_name" id="guest_name"
                                   class="form-control @error('guest_name') is-invalid @enderror"
                                   value="{{ old('guest_name') }}"
                                   placeholder="Nama lengkap Anda" required>
                            @error('guest_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="guest_email" class="form-label">
                                Email <span class="text-danger">*</span>
                            </label>
                            <input type="email" name="guest_email" id="guest_email"
                                   class="form-control @error('guest_email') is-invalid @enderror"
                                   value="{{ old('guest_email') }}"
                                   placeholder="email@example.com" required>
                            <small class="text-muted">Untuk konfirmasi reservasi</small>
                            @error('guest_email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="guest_phone" class="form-label">
                                No. Telepon <span class="text-danger">*</span>
                            </label>
                            <input type="tel" name="guest_phone" id="guest_phone"
                                   class="form-control @error('guest_phone') is-invalid @enderror"
                                   value="{{ old('guest_phone') }}"
                                   placeholder="08123456789" required>
                            <small class="text-muted">Untuk konfirmasi dan komunikasi</small>
                            @error('guest_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <hr class="my-4">
                        @endguest

                        @auth
                        <div class="alert alert-success mb-4">
                            <i class="ri-check-line me-2"></i>
                            Reservasi atas nama: <strong>{{ Auth::user()->name }}</strong>
                        </div>
                        @endauth

                        {{-- Special Requests --}}
                        <div class="mb-4">
                            <label for="special_requests" class="form-label fw-bold">
                                <i class="ri-message-2-line me-1"></i>Permintaan Khusus
                                <small class="text-muted">(Opsional)</small>
                            </label>
                            <textarea name="special_requests" id="special_requests"
                                      class="form-control @error('special_requests') is-invalid @enderror"
                                      rows="3"
                                      placeholder="Contoh: Dekat jendela, high chair untuk anak, perayaan ulang tahun, dll.">{{ old('special_requests') }}</textarea>
                            @error('special_requests')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Important Notes --}}
                        <div class="alert alert-warning">
                            <h6 class="alert-heading"><i class="ri-alert-line me-2"></i>Catatan Penting:</h6>
                            <ul class="mb-0 small">
                                <li>Reservasi akan menunggu konfirmasi dari pihak restoran</li>
                                <li>Mohon datang 10 menit sebelum waktu reservasi</li>
                                <li>Reservasi dapat dibatalkan maksimal 2 jam sebelum waktu yang ditentukan</li>
                                <li>Keterlambatan lebih dari 15 menit dapat mengakibatkan pembatalan otomatis</li>
                            </ul>
                        </div>

                        {{-- Submit Button --}}
                        <div class="d-grid gap-2 mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="ri-calendar-check-line me-2"></i>Buat Reservasi
                            </button>
                            <a href="{{ route('welcome') }}" class="btn btn-outline-secondary">
                                <i class="ri-arrow-left-line me-2"></i>Kembali
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            {{-- Additional Info --}}
            <div class="text-center mt-4">
                <p class="text-muted">
                    <i class="ri-question-line me-1"></i>
                    Sudah punya reservasi? <a href="{{ route('customer.reservations.index') }}">Lihat reservasi saya</a>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Auto-format phone number
    document.getElementById('guest_phone')?.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        e.target.value = value;
    });

    // Form validation
    document.getElementById('reservationForm').addEventListener('submit', function(e) {
        const partySize = document.getElementById('party_size').value;
        if (partySize > 10) {
            if (!confirm('Reservasi untuk lebih dari 10 orang mungkin memerlukan persetujuan khusus. Lanjutkan?')) {
                e.preventDefault();
            }
        }
    });
</script>
@endpush
