@extends('layouts.guest-order')

@section('title', 'Reservasi Saya')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            {{-- Header --}}
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h2 class="fw-bold mb-1">📅 Reservasi Saya</h2>
                    <p class="text-muted mb-0">Kelola dan lihat status reservasi Anda</p>
                </div>
                <div>
                    <a href="{{ route('customer.reservations.create') }}" class="btn btn-primary">
                        <i class="ri-add-line me-1"></i>Buat Reservasi Baru
                    </a>
                </div>
            </div>

            {{-- Success/Error Messages --}}
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ri-check-line me-2"></i>
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif

            @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ri-error-warning-line me-2"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif

            {{-- Reservations List --}}
            @if($reservations->isEmpty())
            <div class="card shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="ri-calendar-line" style="font-size: 4rem; opacity: 0.3;"></i>
                    <h5 class="mt-3 mb-2">Belum Ada Reservasi</h5>
                    <p class="text-muted mb-4">Anda belum memiliki reservasi. Buat reservasi pertama Anda sekarang!</p>
                    <a href="{{ route('customer.reservations.create') }}" class="btn btn-primary">
                        <i class="ri-calendar-check-line me-1"></i>Buat Reservasi
                    </a>
                </div>
            </div>
            @else
            <div class="row g-3">
                @foreach($reservations as $reservation)
                @php
                    $statusColors = [
                        'pending' => 'warning',
                        'confirmed' => 'success',
                        'cancelled' => 'danger',
                        'completed' => 'info',
                        'no_show' => 'secondary'
                    ];
                    $statusIcons = [
                        'pending' => 'ri-time-line',
                        'confirmed' => 'ri-check-double-line',
                        'cancelled' => 'ri-close-circle-line',
                        'completed' => 'ri-check-line',
                        'no_show' => 'ri-indeterminate-circle-line'
                    ];
                    $color = $statusColors[$reservation->status] ?? 'secondary';
                    $icon = $statusIcons[$reservation->status] ?? 'ri-information-line';
                    
                    // Check if reservation is upcoming
                    $reservationDateTime = \Carbon\Carbon::parse($reservation->reservation_date->format('Y-m-d') . ' ' . $reservation->reservation_time->format('H:i:s'));
                    $isUpcoming = $reservationDateTime->isFuture() && in_array($reservation->status, ['pending', 'confirmed']);
                @endphp

                <div class="col-12">
                    <div class="card shadow-sm h-100 {{ $isUpcoming ? 'border-primary' : '' }}">
                        <div class="card-body">
                            <div class="row align-items-center">
                                {{-- Reservation Info --}}
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start mb-2">
                                        <div class="flex-grow-1">
                                            <h5 class="mb-1">
                                                <i class="ri-store-line text-primary me-1"></i>
                                                {{ $reservation->outlet->name }}
                                            </h5>
                                            <p class="text-muted mb-2 small">
                                                Nomor: <span class="fw-bold">{{ $reservation->reservation_number }}</span>
                                            </p>
                                        </div>
                                        <span class="badge bg-{{ $color }} ms-2">
                                            <i class="{{ $icon }} me-1"></i>{{ ucfirst($reservation->status) }}
                                        </span>
                                    </div>

                                    <div class="row g-2 text-muted small">
                                        <div class="col-sm-6">
                                            <i class="ri-calendar-line me-1"></i>
                                            <strong>{{ \Carbon\Carbon::parse($reservation->reservation_date)->format('d M Y') }}</strong>
                                        </div>
                                        <div class="col-sm-6">
                                            <i class="ri-time-line me-1"></i>
                                            <strong>{{ \Carbon\Carbon::parse($reservation->reservation_time)->format('H:i') }} WIB</strong>
                                        </div>
                                        <div class="col-sm-6">
                                            <i class="ri-group-line me-1"></i>
                                            {{ $reservation->party_size }} Orang
                                        </div>
                                        @if($reservation->table)
                                        <div class="col-sm-6">
                                            <i class="ri-table-line me-1"></i>
                                            Meja: {{ $reservation->table->table_number }}
                                        </div>
                                        @endif
                                    </div>

                                    @if($reservation->special_requests)
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            <i class="ri-message-2-line me-1"></i>
                                            {{ Str::limit($reservation->special_requests, 80) }}
                                        </small>
                                    </div>
                                    @endif
                                </div>

                                {{-- Actions --}}
                                <div class="col-md-4 mt-3 mt-md-0">
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('customer.reservations.show', $reservation->reservation_number) }}"
                                           class="btn btn-outline-primary btn-sm">
                                            <i class="ri-eye-line me-1"></i>Lihat Detail
                                        </a>

                                        @if($reservation->canBeCancelled() && $reservationDateTime->diffInHours(now()) >= 2)
                                        <form action="{{ route('customer.reservations.cancel', $reservation->reservation_number) }}"
                                              method="POST"
                                              onsubmit="return confirm('Apakah Anda yakin ingin membatalkan reservasi ini?');">
                                            @csrf
                                            <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                                <i class="ri-close-circle-line me-1"></i>Batalkan
                                            </button>
                                        </form>
                                        @endif
                                    </div>

                                    @if($isUpcoming)
                                    <div class="alert alert-info mt-2 mb-0 py-2 px-2 small text-center">
                                        <i class="ri-alarm-line me-1"></i>
                                        {{ $reservationDateTime->diffForHumans() }}
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            @endif

            {{-- Back Button --}}
            <div class="text-center mt-4">
                <a href="{{ route('welcome') }}" class="btn btn-outline-secondary">
                    <i class="ri-arrow-left-line me-1"></i>Kembali ke Home
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Auto-refresh untuk upcoming reservations
    @if($reservations->where('status', 'pending')->count() > 0)
    setTimeout(function() {
        toastr.info('Refresh halaman untuk melihat update status reservasi terbaru', 'Info', {
            timeOut: 5000,
            preventDuplicates: true
        });
    }, 60000); // Show notification after 1 minute
    @endif
</script>
@endpush
