@extends('layouts.guest-order')

@section('title', 'Detail Reservasi - ' . $reservation->reservation_number)

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            {{-- Success/Error Messages --}}
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ri-check-line me-2"></i>
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif

            @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ri-error-warning-line me-2"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif

            {{-- Header with Status --}}
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h3 class="mb-2 fw-bold">
                                <i class="ri-calendar-check-line text-primary me-2"></i>
                                Detail Reservasi
                            </h3>
                            <p class="text-muted mb-0">Nomor: <span class="fw-bold">{{ $reservation->reservation_number }}</span></p>
                        </div>
                        <div class="col-md-4 text-md-end mt-3 mt-md-0">
                            @php
                                $statusColors = [
                                    'pending' => 'warning',
                                    'confirmed' => 'success',
                                    'cancelled' => 'danger',
                                    'completed' => 'info',
                                    'no_show' => 'secondary'
                                ];
                                $statusIcons = [
                                    'pending' => 'ri-time-line',
                                    'confirmed' => 'ri-check-double-line',
                                    'cancelled' => 'ri-close-circle-line',
                                    'completed' => 'ri-check-line',
                                    'no_show' => 'ri-indeterminate-circle-line'
                                ];
                                $color = $statusColors[$reservation->status] ?? 'secondary';
                                $icon = $statusIcons[$reservation->status] ?? 'ri-information-line';
                            @endphp
                            <span class="badge bg-{{ $color }} px-3 py-2" style="font-size: 1rem;">
                                <i class="{{ $icon }} me-1"></i>{{ ucfirst($reservation->status) }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                {{-- Main Info --}}
                <div class="col-lg-8 mb-4">
                    {{-- Booking Details --}}
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0"><i class="ri-information-line me-2"></i>Informasi Reservasi</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-store-2-line text-primary" style="font-size: 1.5rem;"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Outlet</small>
                                            <strong>{{ $reservation->outlet->name }}</strong>
                                            @if($reservation->outlet->address)
                                            <p class="mb-0 small text-muted">{{ $reservation->outlet->address }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-calendar-line text-primary" style="font-size: 1.5rem;"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Tanggal & Waktu</small>
                                            <strong>{{ \Carbon\Carbon::parse($reservation->reservation_date)->format('d F Y') }}</strong>
                                            <p class="mb-0">{{ \Carbon\Carbon::parse($reservation->reservation_time)->format('H:i') }} WIB</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-group-line text-primary" style="font-size: 1.5rem;"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Jumlah Tamu</small>
                                            <strong>{{ $reservation->party_size }} Orang</strong>
                                        </div>
                                    </div>
                                </div>

                                @if($reservation->table)
                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-table-line text-primary" style="font-size: 1.5rem;"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Nomor Meja</small>
                                            <strong>{{ $reservation->table->table_number }}</strong>
                                            <small class="text-muted">(Kapasitas: {{ $reservation->table->capacity }} orang)</small>
                                        </div>
                                    </div>
                                </div>
                                @else
                                <div class="col-md-6">
                                    <div class="alert alert-info mb-0 py-2">
                                        <i class="ri-information-line me-1"></i>
                                        <small>Meja akan ditentukan saat konfirmasi</small>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Customer Info --}}
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="ri-user-line me-2"></i>Informasi Pemesan</h6>
                        </div>
                        <div class="card-body">
                            @if($reservation->user)
                            <p class="mb-2">
                                <i class="ri-user-3-line me-2 text-muted"></i>
                                <strong>{{ $reservation->user->name }}</strong>
                            </p>
                            <p class="mb-2">
                                <i class="ri-mail-line me-2 text-muted"></i>
                                {{ $reservation->user->email }}
                            </p>
                            @if($reservation->user->phone)
                            <p class="mb-0">
                                <i class="ri-phone-line me-2 text-muted"></i>
                                {{ $reservation->user->phone }}
                            </p>
                            @endif
                            @else
                            {{-- Guest Info --}}
                            @php $guestInfo = $reservation->guest_info; @endphp
                            <p class="mb-2">
                                <i class="ri-user-3-line me-2 text-muted"></i>
                                <strong>{{ $guestInfo['name'] ?? 'N/A' }}</strong>
                                <span class="badge bg-secondary ms-2">Guest</span>
                            </p>
                            <p class="mb-2">
                                <i class="ri-mail-line me-2 text-muted"></i>
                                {{ $guestInfo['email'] ?? 'N/A' }}
                            </p>
                            <p class="mb-0">
                                <i class="ri-phone-line me-2 text-muted"></i>
                                {{ $guestInfo['phone'] ?? 'N/A' }}
                            </p>
                            @endif
                        </div>
                    </div>

                    {{-- Special Requests --}}
                    @if($reservation->special_requests)
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="ri-message-2-line me-2"></i>Permintaan Khusus</h6>
                        </div>
                        <div class="card-body">
                            <p class="mb-0">{{ $reservation->special_requests }}</p>
                        </div>
                    </div>
                    @endif
                </div>

                {{-- Sidebar --}}
                <div class="col-lg-4">
                    {{-- Actions --}}
                    @php
                        $reservationDateTime = \Carbon\Carbon::parse($reservation->reservation_date->format('Y-m-d') . ' ' . $reservation->reservation_time->format('H:i:s'));
                        $canCancel = $reservation->canBeCancelled() && $reservationDateTime->diffInHours(now()) >= 2 && $reservationDateTime->isFuture();
                    @endphp

                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="ri-settings-3-line me-2"></i>Tindakan</h6>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                @if($canCancel)
                                <form action="{{ route('customer.reservations.cancel', $reservation->reservation_number) }}"
                                      method="POST"
                                      onsubmit="return confirm('Apakah Anda yakin ingin membatalkan reservasi ini?');">
                                    @csrf
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="ri-close-circle-line me-1"></i>Batalkan Reservasi
                                    </button>
                                </form>
                                <small class="text-muted text-center">
                                    <i class="ri-information-line me-1"></i>
                                    Dapat dibatalkan hingga 2 jam sebelum reservasi
                                </small>
                                @elseif($reservation->status === 'pending' || $reservation->status === 'confirmed')
                                <div class="alert alert-warning mb-0 py-2">
                                    <small>
                                        <i class="ri-time-line me-1"></i>
                                        Reservasi tidak dapat dibatalkan kurang dari 2 jam sebelum waktu reservasi
                                    </small>
                                </div>
                                @endif

                                <a href="{{ route('customer.reservations.index') }}" class="btn btn-outline-secondary">
                                    <i class="ri-list-check me-1"></i>Lihat Semua Reservasi
                                </a>

                                <a href="{{ route('welcome') }}" class="btn btn-outline-primary">
                                    <i class="ri-home-line me-1"></i>Kembali ke Home
                                </a>
                            </div>
                        </div>
                    </div>

                    {{-- Timeline --}}
                    <div class="card shadow-sm">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="ri-time-line me-2"></i>Timeline</h6>
                        </div>
                        <div class="card-body">
                            <div class="timeline">
                                {{-- Created --}}
                                <div class="timeline-item">
                                    <div class="timeline-marker bg-primary"></div>
                                    <div class="timeline-content">
                                        <small class="text-muted">Dibuat</small>
                                        <p class="mb-0 fw-bold">{{ $reservation->created_at->format('d M Y, H:i') }}</p>
                                    </div>
                                </div>

                                {{-- Confirmed --}}
                                @if($reservation->confirmed_at)
                                <div class="timeline-item">
                                    <div class="timeline-marker bg-success"></div>
                                    <div class="timeline-content">
                                        <small class="text-muted">Dikonfirmasi</small>
                                        <p class="mb-0 fw-bold">{{ $reservation->confirmed_at->format('d M Y, H:i') }}</p>
                                    </div>
                                </div>
                                @endif

                                {{-- Cancelled --}}
                                @if($reservation->cancelled_at)
                                <div class="timeline-item">
                                    <div class="timeline-marker bg-danger"></div>
                                    <div class="timeline-content">
                                        <small class="text-muted">Dibatalkan</small>
                                        <p class="mb-0 fw-bold">{{ $reservation->cancelled_at->format('d M Y, H:i') }}</p>
                                    </div>
                                </div>
                                @endif

                                {{-- Reservation Date --}}
                                @if(in_array($reservation->status, ['pending', 'confirmed']))
                                <div class="timeline-item">
                                    <div class="timeline-marker bg-info"></div>
                                    <div class="timeline-content">
                                        <small class="text-muted">Jadwal Reservasi</small>
                                        <p class="mb-0 fw-bold">
                                            {{ \Carbon\Carbon::parse($reservation->reservation_date)->format('d M Y') }},
                                            {{ \Carbon\Carbon::parse($reservation->reservation_time)->format('H:i') }}
                                        </p>
                                        <small class="text-primary">{{ $reservationDateTime->diffForHumans() }}</small>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Status Info --}}
                    <div class="card shadow-sm mt-4">
                        <div class="card-body">
                            @if($reservation->status === 'pending')
                            <div class="alert alert-warning mb-0">
                                <h6 class="alert-heading"><i class="ri-time-line me-2"></i>Menunggu Konfirmasi</h6>
                                <p class="mb-0 small">Reservasi Anda sedang dalam proses peninjauan. Anda akan menerima konfirmasi melalui email/telepon.</p>
                            </div>
                            @elseif($reservation->status === 'confirmed')
                            <div class="alert alert-success mb-0">
                                <h6 class="alert-heading"><i class="ri-check-double-line me-2"></i>Reservasi Dikonfirmasi</h6>
                                <p class="mb-0 small">Reservasi Anda telah dikonfirmasi! Mohon datang tepat waktu.</p>
                            </div>
                            @elseif($reservation->status === 'cancelled')
                            <div class="alert alert-danger mb-0">
                                <h6 class="alert-heading"><i class="ri-close-circle-line me-2"></i>Reservasi Dibatalkan</h6>
                                <p class="mb-0 small">Reservasi ini telah dibatalkan.</p>
                            </div>
                            @elseif($reservation->status === 'completed')
                            <div class="alert alert-info mb-0">
                                <h6 class="alert-heading"><i class="ri-check-line me-2"></i>Reservasi Selesai</h6>
                                <p class="mb-0 small">Terima kasih telah menggunakan layanan kami!</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 8px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #dee2e6;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-item:last-child {
    margin-bottom: 0;
}

.timeline-marker {
    position: absolute;
    left: -26px;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    border: 2px solid white;
}

.timeline-content {
    padding-left: 10px;
}
</style>
@endsection
