<?php $__env->startSection('title', 'Manajemen Reservasi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Manajemen Reservasi</h4>
                    <a href="<?php echo e(route('reservations.create')); ?>" class="btn btn-primary">
                        <i class="ri-add-line me-1"></i>Buat Reservasi Baru
                    </a>
                </div>
                <div class="card-body">
                    
                    <div class="row mb-4">
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Total Reservasi</h6>
                                    <h3 class="mb-0"><?php echo e(number_format($stats['total_reservations'])); ?></h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-warning text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Menunggu Konfirmasi</h6>
                                    <h3 class="mb-0"><?php echo e(number_format($stats['pending_reservations'])); ?></h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Dikonfirmasi</h6>
                                    <h3 class="mb-0"><?php echo e(number_format($stats['confirmed_reservations'])); ?></h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-12 mb-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h6 class="card-title">Hari Ini</h6>
                                    <h3 class="mb-0"><?php echo e(number_format($stats['today_reservations'])); ?></h3>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <form method="GET" class="row g-3 mb-4">
                        <div class="col-md-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="">Semua Status</option>
                                <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value); ?>" <?php echo e(request('status') == $value ? 'selected' : ''); ?>>
                                    <?php echo e($label); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Outlet</label>
                            <select name="outlet_id" class="form-select">
                                <option value="">Semua Outlet</option>
                                <?php $__currentLoopData = $outlets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outlet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($outlet->id); ?>" <?php echo e(request('outlet_id') == $outlet->id ? 'selected' : ''); ?>>
                                    <?php echo e($outlet->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Tanggal</label>
                            <input type="date" name="date" class="form-control" value="<?php echo e(request('date')); ?>">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" class="btn btn-primary d-block w-100">
                                <i class="ri-search-line me-1"></i>Filter
                            </button>
                        </div>
                    </form>

                    
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No. Reservasi</th>
                                    <th>Customer</th>
                                    <th>Outlet</th>
                                    <th>Meja</th>
                                    <th>Tanggal & Waktu</th>
                                    <th>Jumlah Orang</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reservations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reservation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><strong><?php echo e($reservation->reservation_number); ?></strong></td>
                                    <td>
                                        <?php echo e($reservation->customer_name); ?>

                                        <br><small class="text-muted"><?php echo e($reservation->customer_email); ?></small>
                                    </td>
                                    <td><?php echo e($reservation->outlet->name); ?></td>
                                    <td>
                                        <?php if($reservation->table): ?>
                                            <span class="badge bg-label-info"><?php echo e($reservation->table->table_number); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-label-secondary">Belum ditentukan</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($reservation->formatted_date_time); ?></td>
                                    <td><?php echo e($reservation->party_size); ?> orang</td>
                                    <td>
                                        <span class="badge bg-label-<?php echo e($reservation->status === 'confirmed' ? 'success' :
                                            ($reservation->status === 'pending' ? 'warning' :
                                            ($reservation->status === 'completed' ? 'info' :
                                            ($reservation->status === 'cancelled' ? 'danger' : 'secondary')))); ?>">
                                            <?php echo e($statuses[$reservation->status]); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('reservations.show', $reservation)); ?>" class="btn btn-sm btn-info">
                                            <i class="ri-eye-line"></i>
                                        </a>
                                        <a href="<?php echo e(route('reservations.edit', $reservation)); ?>" class="btn btn-sm btn-warning">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="ri-calendar-line ri-3x text-muted"></i>
                                        <p class="text-muted mt-2">Tidak ada reservasi ditemukan.</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="mt-3">
                        <?php echo e($reservations->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    <?php if(session('success')): ?>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '<?php echo e(session('success')); ?>',
            timer: 3000
        });
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/console/reservations/index.blade.php ENDPATH**/ ?>