<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
            <!-- Quick Actions -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title">Quick Actions</h6>
                            <div class="d-flex gap-2 flex-wrap">
                                <a href="<?php echo e(route('console.orders.index')); ?>" class="btn btn-primary mb-2">
                                    <i class="ri-shopping-cart-line me-1"></i> Manage Orders
                                </a>
                                <a href="<?php echo e(route('console.reporting.index')); ?>" class="btn btn-info mb-2">
                                    <i class="ri-bar-chart-line me-1"></i> View Reports
                                </a>
                                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-success mb-2">
                                    <i class="ri-cup-line me-1"></i> Manage Products
                                </a>
                                <a href="<?php echo e(route('outlets.index')); ?>" class="btn btn-warning mb-2">
                                    <i class="ri-store-line me-1"></i> Manage Outlets
                                </a>
                                <a href="<?php echo e(route('reservations.index')); ?>" class="btn btn-secondary mb-2">
                                    <i class="ri-calendar-line me-1"></i> Reservations
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Info Alert -->
            <div class="row mb-3">
                <div class="col-12">
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="ri-information-line me-2"></i>
                        <strong>Periode Data:</strong> Dashboard ini menampilkan data <strong>Hari Ini</strong> dan <strong>Bulan Ini</strong>.
                        Untuk melihat periode custom atau 30 hari terakhir, klik tombol <strong>"View Reports"</strong> di atas.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
            <!-- KPI Cards -->
            <div class="row mb-4">
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center bg-success text-white">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-money-dollar-circle-line ri-2x"></i></div>
                            <h6 class="mb-1">Omzet Hari Ini</h6>
                            <h4 class="mb-0">Rp <?php echo e(number_format($omzetToday, 0, ',', '.')); ?></h4>
                            <small class="opacity-75"><?php echo e(\Carbon\Carbon::now()->format('d M Y')); ?></small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center bg-primary text-white">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-bar-chart-line ri-2x"></i></div>
                            <h6 class="mb-1">Omzet Bulan Ini</h6>
                            <h4 class="mb-0">Rp <?php echo e(number_format($omzetMonth, 0, ',', '.')); ?></h4>
                            <small class="opacity-75"><?php echo e(\Carbon\Carbon::now()->format('M Y')); ?></small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center bg-warning text-white">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-shopping-cart-2-line ri-2x"></i></div>
                            <h6 class="mb-1">Pesanan Hari Ini</h6>
                            <h4 class="mb-0"><?php echo e($ordersToday); ?></h4>
                            <small class="opacity-75">
                                Paid: <?php echo e($ordersTodayPaid); ?> |
                                <?php if($ordersTodayCancelled > 0): ?>
                                    <span class="text-danger">Cancelled: <?php echo e($ordersTodayCancelled); ?></span>
                                <?php else: ?>
                                    Cancelled: 0
                                <?php endif; ?>
                            </small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center bg-info text-white">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-shopping-bag-3-line ri-2x"></i></div>
                            <h6 class="mb-1">Pesanan Bulan Ini</h6>
                            <h4 class="mb-0"><?php echo e($ordersMonth); ?></h4>
                            <small class="opacity-75">
                                Paid: <?php echo e($ordersMonthPaid); ?> |
                                <?php if($ordersMonthCancelled > 0): ?>
                                    <span class="text-danger">Cancelled: <?php echo e($ordersMonthCancelled); ?></span>
                                <?php else: ?>
                                    Cancelled: 0
                                <?php endif; ?>
                            </small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-user-add-line ri-2x"></i></div>
                            <h6 class="mb-1">Pelanggan Baru</h6>
                            <h4 class="mb-0"><?php echo e($newCustomersMonth); ?></h4>
                            <small class="opacity-75"><?php echo e(\Carbon\Carbon::now()->format('M Y')); ?></small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center bg-secondary text-white">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-cup-line ri-2x"></i></div>
                            <h6 class="mb-1">Produk Tersedia</h6>
                            <h4 class="mb-0"><?php echo e($availableProducts); ?></h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center" style="background-color: #6c757d; color: white;">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-table-line ri-2x"></i></div>
                            <h6 class="mb-1">Meja Tersedia</h6>
                            <h4 class="mb-0"><?php echo e($availableTables); ?></h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="card text-center border border-primary">
                        <div class="card-body">
                            <div class="mb-2"><i class="ri-bar-chart-box-line ri-2x text-primary"></i></div>
                            <h6 class="mb-1">Lihat Laporan Lengkap</h6>
                            <a href="<?php echo e(route('console.reporting.index')); ?>" class="btn btn-primary btn-sm mt-2">
                                <i class="ri-arrow-right-line me-1"></i>Reporting
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Grafik Omzet & Pesanan 7 Hari Terakhir -->
            <div class="row mb-4">
                <div class="col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-header"><b>Grafik Omzet 7 Hari Terakhir</b></div>
                        <div class="card-body">
                            <canvas id="omzetChart"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-header"><b>Grafik Pesanan 7 Hari Terakhir</b></div>
                        <div class="card-body">
                            <canvas id="ordersChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Produk Terlaris & Produk Jarang Terjual -->
            <div class="row mb-4">
                <div class="col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-header"><b>Top 5 Produk Terlaris</b></div>
                        <div class="card-body p-0">
                            <table class="table mb-0">
                                <thead>
                                    <tr>
                                        <th>Produk</th>
                                        <th class="text-end">Terjual</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($product->name); ?></td>
                                            <td class="text-end"><?php echo e($product->total_sold ?? 0); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr><td colspan="2" class="text-center">Tidak ada data</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-header"><b>Produk yang Jarang Terjual</b></div>
                        <div class="card-body p-0">
                            <table class="table mb-0">
                                <thead>
                                    <tr>
                                        <th>Produk</th>
                                        <th class="text-end">Terjual</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $rarelySoldProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($product->name); ?></td>
                                            <td class="text-end"><?php echo e($product->total_sold ?? 0); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr><td colspan="2" class="text-center">Aman</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pesanan Terbaru -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header"><b>5 Pesanan Terbaru</b></div>
                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Nomor Pesanan</th>
                                        <th>Pelanggan</th>
                                        <th>Outlet</th>
                                        <th>Meja</th>
                                        <th>Total</th>
                                        <th>Status Pembayaran</th>
                                        <th>Waktu Pesan</th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    <?php $__empty_1 = true; $__currentLoopData = $latestOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><span class="fw-medium"><?php echo e($order->order_number); ?></span></td>
                                            <td><?php echo e($order->user->name ?? 'Guest'); ?></td>
                                            <td><?php echo e($order->outlet->name); ?></td>
                                            <td><?php echo e($order->table->table_number); ?></td>
                                            <td>Rp <?php echo e(number_format($order->total_amount, 0, ',', '.')); ?></td>
                                            <td><span class="badge bg-label-<?php echo e($order->payment_status === 'paid' ? 'success' : 'warning'); ?>"><?php echo e($statusBayarIndo[$order->payment_status] ?? ucfirst($order->payment_status)); ?></span></td>
                                            <td><?php echo e($order->ordered_at->format('d M Y H:i')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" class="text-center">Tidak ada pesanan terbaru.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Chart.js CDN & Script -->
            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <script>
                const omzetCtx = document.getElementById('omzetChart').getContext('2d');
                const ordersCtx = document.getElementById('ordersChart').getContext('2d');
                const omzetChart = new Chart(omzetCtx, {
                    type: 'line',
                    data: {
                        labels: <?php echo json_encode($dates->map(fn($d) => \Carbon\Carbon::parse($d)->format('d M')), 15, 512) ?>,
                        datasets: [{
                            label: 'Omzet',
                            data: <?php echo json_encode(array_values($omzet7days->toArray()), 15, 512) ?>,
                            borderColor: '#28a745',
                            backgroundColor: 'rgba(40,167,69,0.1)',
                            fill: true,
                            tension: 0.4
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: { legend: { display: false } }
                    }
                });
                const ordersChart = new Chart(ordersCtx, {
                    type: 'bar',
                    data: {
                        labels: <?php echo json_encode($dates->map(fn($d) => \Carbon\Carbon::parse($d)->format('d M')), 15, 512) ?>,
                        datasets: [{
                            label: 'Pesanan',
                            data: <?php echo json_encode(array_values($orders7days->toArray()), 15, 512) ?>,
                            backgroundColor: '#17a2b8',
                            borderRadius: 6
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: { legend: { display: false } }
                    }
                });
            </script>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'kasir')): ?>
            <!-- Quick Actions -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title">Quick Actions</h6>
                            <div class="d-flex gap-2">
                                <a href="<?php echo e(route('console.orders.index')); ?>" class="btn btn-primary">
                                    <i class="ri-shopping-cart-line me-1"></i>Manage Orders
                                </a>
                                <a href="<?php echo e(route('console.reporting.index')); ?>" class="btn btn-info">
                                    <i class="ri-bar-chart-line me-1"></i>View Reports
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="row mb-4">
                <div class="col-lg-3 col-md-6 col-12 mb-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h6 class="card-title">Pending Orders</h6>
                                    <h3 class="mb-0"><?php echo e($quickStats['pending_orders']); ?></h3>
                                </div>
                                <div class="align-self-center">
                                    <i class="ri-time-line ri-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-12 mb-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h6 class="card-title">Processing</h6>
                                    <h3 class="mb-0"><?php echo e($quickStats['processing_orders']); ?></h3>
                                </div>
                                <div class="align-self-center">
                                    <i class="ri-settings-3-line ri-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-12 mb-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h6 class="card-title">Today Revenue</h6>
                                    <h3 class="mb-0">Rp <?php echo e(number_format($quickStats['today_revenue'])); ?></h3>
                                </div>
                                <div class="align-self-center">
                                    <i class="ri-money-dollar-circle-line ri-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-12 mb-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h6 class="card-title">Available Tables</h6>
                                    <h3 class="mb-0"><?php echo e($quickStats['available_tables']); ?></h3>
                                </div>
                                <div class="align-self-center">
                                    <i class="ri-table-line ri-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Pesanan Menunggu Pembayaran -->
                <div class="col-lg-6 col-md-6 col-sm-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="card-title mb-0">
                                    <h5 class="mb-0">Pesanan Menunggu Pembayaran</h5>
                                    <small class="text-muted">Total</small>
                                </div>
                                <div class="avatar flex-shrink-0">
                                    <span class="avatar-initial rounded bg-label-warning">
                                        <i class="ri-time-line ri-24px"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="mt-4">
                                <h3 class="mb-0"><?php echo e($pendingOrdersCount); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Total Omzet Hari Ini (Kasir) -->
                <div class="col-lg-6 col-md-6 col-sm-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="card-title mb-0">
                                    <h5 class="mb-0">Total Omzet Hari Ini</h5>
                                    <small class="text-muted"><?php echo e(\Carbon\Carbon::now()->format('d M Y')); ?></small>
                                </div>
                                <div class="avatar flex-shrink-0">
                                    <span class="avatar-initial rounded bg-label-success">
                                        <i class="ri-money-dollar-circle-line ri-24px"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="mt-4">
                                <h3 class="mb-0">Rp <?php echo e(number_format($completedOrdersToday, 0, ',', '.')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 mb-4 order-0">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Pesanan Menunggu Pembayaran</h5>
                        </div>
                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Nomor Pesanan</th>
                                        <th>Pelanggan</th>
                                        <th>Meja</th>
                                        <th>Total</th>
                                        <th>Metode Pembayaran</th>
                                        <th>Waktu Pesan</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    <?php $__empty_1 = true; $__currentLoopData = $pendingOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><span class="fw-medium"><?php echo e($order->order_number); ?></span></td>
                                            <td><?php echo e($order->user->name ?? ($order->guest_info['name'] ?? 'Guest')); ?></td>
                                            <td><?php echo e($order->table->table_number); ?></td>
                                            <td>Rp <?php echo e(number_format($order->total_amount, 0, ',', '.')); ?></td>
                                            <td><?php echo e(Str::ucfirst($order->payment_method)); ?></td>
                                            <td><?php echo e($order->ordered_at->format('d M Y H:i')); ?></td>
                                            <td>
                                                <div class="d-flex gap-2">
                                                    <a href="<?php echo e(route('console.orders.show', $order->id)); ?>" class="btn btn-info btn-sm" title="Lihat Detail"><i class="ri-eye-line"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">Tidak ada pesanan menunggu pembayaran.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        

        <?php if(!auth()->user()->hasAnyRole('admin', 'kasir', 'user')): ?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card text-center">
                        <div class="card-body">
                            <h4 class="card-title">Selamat Datang!</h4>
                            <p class="card-text">Anda belum memiliki peran. Silakan hubungi administrator.</p>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/dashboard.blade.php ENDPATH**/ ?>