<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card">

            <div class="card-header border-bottom">
                <h5 class="card-title mb-0">Filters</h5>
                <div class="d-flex justify-content-between align-items-center row gx-5 pt-4 gap-5 gap-md-0">
                    <div class="col-md-4 user_role">
                        <select id="user-role-filter" class="form-select" data-filter="role" name="role_filter">
                            <option value="">Select Role</option>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="card-datatable table-responsive">
                <?php echo e($dataTable->table(['class' => 'datatables-permissions table'])); ?>

            </div>

            <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAddUser"
                aria-labelledby="offcanvasAddUserLabel">
                <div class="offcanvas-header border-bottom">
                    <h5 id="offcanvasAddUserLabel" class="offcanvas-title">Add User</h5>
                    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                        aria-label="Close"></button>
                </div>

                <div class="offcanvas-body mx-0 flex-grow-0 h-100">
                    <form class="add-new-user pt-0" id="addNewUserForm" method="POST" onsubmit="return false"
                        action="<?php echo e(route('users.store')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="form-floating form-floating-outline mb-5">
                            <input type="text" class="form-control" id="add-user-name" placeholder="John Doe"
                                name="name" aria-label="John Doe" />
                            <label for="add-user-name">Name</label>
                        </div>

                        <div class="form-floating form-floating-outline mb-5">
                            <input type="text" id="add-user-email" class="form-control"
                                placeholder="john.doe@example.com" aria-label="john.doe@example.com" name="email" />
                            <label for="add-user-email">Email</label>
                        </div>

                        <div class="form-floating form-floating-outline mb-5">
                            <select id="user-role" class="form-select" name="role_id">
                                <option value="">Select Role</option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label for="user-role">User Role</label>
                        </div>

                        <div class="form-floating form-floating-outline mb-5">
                            <input type="password" id="add-user-password" class="form-control"
                                placeholder="<?php echo passwordPlainText(); ?>" aria-label="<?php echo passwordPlainText(); ?>"
                                name="password" />
                            <label for="add-user-password">Password</label>
                        </div>

                        <div class="form-floating form-floating-outline mb-5">
                            <input type="password" id="add-user-password-confirm" class="form-control"
                                placeholder="<?php echo passwordPlainText(); ?>" aria-label="<?php echo passwordPlainText(); ?>"
                                name="password_confirmation" />
                            <label for="add-user-password-confirm">Confirm Password</label>
                        </div>

                        <button type="submit" class="btn btn-primary me-sm-3 me-1 data-submit">Submit</button>
                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
                    </form>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <?php echo e($dataTable->scripts()); ?>


    <script>
        var urlDeleteUser = "<?php echo e(route('users.destroy', ':id')); ?>";
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Function to handle delete record confirmation
            const handleDeleteRecord = (e) => {
                const target = e.target.closest(".delete-record");
                if (!target) return;

                e.preventDefault();

                const recordId = target.getAttribute("data-id");
                if (!recordId) {
                    console.error("Record ID not found.");
                    return;
                }

                const form = document.createElement("form");
                form.method = "POST";
                form.action = urlDeleteUser.replace(":id", recordId);
                form.style.display = "none";

                const csrfToken = document.querySelector('meta[name="csrf-token"]');
                if (csrfToken) {
                    const csrfInput = document.createElement("input");
                    csrfInput.type = "hidden";
                    csrfInput.name = "_token";
                    csrfInput.value = csrfToken.getAttribute("content");
                    form.appendChild(csrfInput);
                }

                const methodInput = document.createElement("input");
                methodInput.type = "hidden";
                methodInput.name = "_method";
                methodInput.value = "DELETE";
                form.appendChild(methodInput);

                document.body.appendChild(form);

                Swal.fire({
                    title: "Are you sure?",
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Yes, delete it!",
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    } else {
                        form.remove();
                    }
                });
            };

            // Attach event listener for delete record
            document.addEventListener("click", handleDeleteRecord);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/console/users/index.blade.php ENDPATH**/ ?>