<?php $__env->startSection('title', 'Edit Reservasi - ' . $reservation->reservation_number); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Edit Reservasi</h4>
                    <a href="<?php echo e(route('reservations.show', $reservation)); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="ri-arrow-left-line me-1"></i>Kembali
                    </a>
                </div>
                <div class="card-body">
                    
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="ri-information-line me-2"></i>
                        <strong>No. Reservasi: <?php echo e($reservation->reservation_number); ?></strong>
                        <br>
                        <small>Dibuat pada: <?php echo e($reservation->created_at->format('d F Y H:i')); ?></small>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>

                    <form action="<?php echo e(route('reservations.update', $reservation)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        
                        <div class="mb-3">
                            <label for="outlet_id" class="form-label">Outlet <span class="text-danger">*</span></label>
                            <select name="outlet_id" id="outlet_id" class="form-select <?php $__errorArgs = ['outlet_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Pilih Outlet</option>
                                <?php $__currentLoopData = $outlets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outlet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($outlet->id); ?>" <?php echo e((old('outlet_id', $reservation->outlet_id) == $outlet->id) ? 'selected' : ''); ?>>
                                    <?php echo e($outlet->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['outlet_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-3">
                            <label for="table_id" class="form-label">Meja <small class="text-muted">(Opsional)</small></label>
                            <select name="table_id" id="table_id" class="form-select <?php $__errorArgs = ['table_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">Belum ditentukan</option>
                                <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($table->id); ?>" <?php echo e((old('table_id', $reservation->table_id) == $table->id) ? 'selected' : ''); ?>>
                                    Meja <?php echo e($table->table_number); ?>

                                    (Kapasitas: <?php echo e($table->capacity ?? 'N/A'); ?>)
                                    <?php if($table->status !== 'available'): ?>
                                        - <?php echo e(ucfirst($table->status)); ?>

                                    <?php endif; ?>
                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['table_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="reservation_date" class="form-label">Tanggal <span class="text-danger">*</span></label>
                                <input type="date" name="reservation_date" id="reservation_date"
                                       class="form-control <?php $__errorArgs = ['reservation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('reservation_date', $reservation->reservation_date->format('Y-m-d'))); ?>"
                                       required>
                                <?php $__errorArgs = ['reservation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="reservation_time" class="form-label">Waktu <span class="text-danger">*</span></label>
                                <input type="time" name="reservation_time" id="reservation_time"
                                       class="form-control <?php $__errorArgs = ['reservation_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('reservation_time', $reservation->reservation_time->format('H:i'))); ?>"
                                       required>
                                <?php $__errorArgs = ['reservation_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="mb-3">
                            <label for="party_size" class="form-label">Jumlah Orang <span class="text-danger">*</span></label>
                            <input type="number" name="party_size" id="party_size"
                                   class="form-control <?php $__errorArgs = ['party_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('party_size', $reservation->party_size)); ?>"
                                   min="1" max="20" required>
                            <?php $__errorArgs = ['party_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__currentLoopData = \App\Models\Reservation::getStatuses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value); ?>" <?php echo e((old('status', $reservation->status) == $value) ? 'selected' : ''); ?>>
                                    <?php echo e($label); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="text-muted">
                                Status saat ini:
                                <span class="badge bg-label-<?php echo e($reservation->status === 'confirmed' ? 'success' :
                                    ($reservation->status === 'pending' ? 'warning' :
                                    ($reservation->status === 'completed' ? 'info' :
                                    ($reservation->status === 'cancelled' ? 'danger' : 'secondary')))); ?>">
                                    <?php echo e(\App\Models\Reservation::getStatuses()[$reservation->status]); ?>

                                </span>
                            </small>
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3">Informasi Customer</h5>

                        
                        <div class="alert alert-light">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Nama:</strong><br>
                                    <?php echo e($reservation->customer_name); ?>

                                </div>
                                <div class="col-md-4">
                                    <strong>Email:</strong><br>
                                    <?php echo e($reservation->customer_email); ?>

                                </div>
                                <div class="col-md-4">
                                    <strong>No. Telepon:</strong><br>
                                    <?php echo e($reservation->customer_phone); ?>

                                </div>
                            </div>
                            <small class="text-muted d-block mt-2">
                                <i class="ri-information-line me-1"></i>
                                Informasi customer tidak dapat diubah. Untuk mengubah, hubungi customer dan buat reservasi baru.
                            </small>
                        </div>

                        
                        <div class="mb-3">
                            <label for="special_requests" class="form-label">Permintaan Khusus</label>
                            <textarea name="special_requests" id="special_requests"
                                      class="form-control <?php $__errorArgs = ['special_requests'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                      rows="3" placeholder="Contoh: Dekat jendela, high chair untuk anak, dll."><?php echo e(old('special_requests', $reservation->special_requests)); ?></textarea>
                            <?php $__errorArgs = ['special_requests'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-3">
                            <label for="notes" class="form-label">Catatan Internal <small class="text-muted">(Tidak dilihat customer)</small></label>
                            <textarea name="notes" id="notes"
                                      class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                      rows="2" placeholder="Catatan untuk staf/kasir..."><?php echo e(old('notes', $reservation->notes)); ?></textarea>
                            <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-between mt-4">
                            <div>
                                <a href="<?php echo e(route('reservations.show', $reservation)); ?>" class="btn btn-secondary">
                                    <i class="ri-arrow-left-line me-1"></i>Batal
                                </a>
                            </div>
                            <div class="d-flex gap-2">
                                <?php if($reservation->canBeCancelled()): ?>
                                <button type="button" class="btn btn-danger" onclick="confirmDelete()">
                                    <i class="ri-close-circle-line me-1"></i>Batalkan Reservasi
                                </button>
                                <?php endif; ?>
                                <button type="submit" class="btn btn-primary">
                                    <i class="ri-save-line me-1"></i>Simpan Perubahan
                                </button>
                            </div>
                        </div>
                    </form>

                    
                    <?php if($reservation->canBeCancelled()): ?>
                    <form id="deleteForm" action="<?php echo e(route('reservations.destroy', $reservation)); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmDelete() {
        Swal.fire({
            title: 'Batalkan Reservasi?',
            text: 'Apakah Anda yakin ingin membatalkan reservasi ini? Tindakan ini tidak dapat dibatalkan.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Ya, Batalkan!',
            cancelButtonText: 'Tidak'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteForm').submit();
            }
        });
    }

    <?php if(session('error')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '<?php echo e(session('error')); ?>'
        });
    <?php endif; ?>

    // Auto-update date minimum to today
    document.addEventListener('DOMContentLoaded', function() {
        const dateInput = document.getElementById('reservation_date');
        const currentStatus = '<?php echo e($reservation->status); ?>';

        // If reservation is not pending or confirmed, don't allow past dates
        if (['completed', 'cancelled', 'no_show'].includes(currentStatus)) {
            // Allow any date for historical records
            dateInput.removeAttribute('min');
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/console/reservations/edit.blade.php ENDPATH**/ ?>