<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="light-style layout-content-navbar" dir="ltr"
    data-theme="theme-default" data-assets-path="<?php echo e(asset('/materialize')); ?>/assets/"
    data-template="vertical-menu-template-no-customizer" data-style="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Solusi Kopi')); ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('/materialize')); ?>/assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap" rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/fonts/remixicon/remixicon.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/fonts/flag-icons.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/css/rtl/theme-default.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/typeahead-js/typeahead.css" />

    
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/flatpickr/flatpickr.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/toastr/toastr.css" />


    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo $__env->yieldPushContent('styles'); ?> 
</head>
<body>
    <!-- Top Navigation (Optional) -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom mb-4">
        <div class="container">
            <a class="navbar-brand fw-bold" href="<?php echo e(route('welcome')); ?>">
                <i class="ri-cup-line me-2 text-primary"></i>
                <?php echo e(config('app.name', 'Solusi Kopi')); ?>

            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('welcome')); ?>">
                            <i class="ri-home-line me-1"></i>Beranda
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('customer.reservations.index')); ?>">
                            <i class="ri-calendar-check-line me-1"></i>Reservasi
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('order.history')); ?>">
                            <i class="ri-history-line me-1"></i>Riwayat
                        </a>
                    </li>
                    <?php if(auth()->guard()->check()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">
                            <i class="ri-dashboard-line me-1"></i>Dashboard
                        </a>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('login')); ?>">
                            <i class="ri-login-box-line me-1"></i>Login
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Core JS -->
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/popper/popper.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/js/bootstrap.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/hammer/hammer.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/moment/moment.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/flatpickr/flatpickr.min.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/toastr/toastr.js"></script>

    
    <script>
        <?php if(session('success')): ?>
            toastr.success("<?php echo e(session('success')); ?>");
        <?php endif; ?>
        <?php if(session('error')): ?>
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>
        <?php if(session('info')): ?>
            toastr.info("<?php echo e(session('info')); ?>");
        <?php endif; ?>
        <?php if(session('warning')): ?>
            toastr.warning("<?php echo e(session('warning')); ?>");
        <?php endif; ?>
    </script>


    <!-- Main JS -->
    <script src="<?php echo e(asset('/materialize')); ?>/assets/js/main.js"></script>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?> 
</body>
</html>
<?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/layouts/guest-order.blade.php ENDPATH**/ ?>