<?php $__env->startSection('title', 'Reservasi Meja'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            
            <div class="text-center mb-5">
                <h2 class="fw-bold">🍽️ Reservasi Meja</h2>
                <p class="text-muted">Pesan meja Anda sekarang dan nikmati pengalaman dining yang lebih nyaman</p>
            </div>

            
            <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ri-error-warning-line me-2"></i>
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ri-check-line me-2"></i>
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            
            <div class="card shadow-sm">
                <div class="card-body p-4">
                    <form action="<?php echo e(route('customer.reservations.store')); ?>" method="POST" id="reservationForm">
                        <?php echo csrf_field(); ?>

                        
                        <div class="mb-4">
                            <label for="outlet_id" class="form-label fw-bold">
                                <i class="ri-store-line me-1"></i>Pilih Outlet <span class="text-danger">*</span>
                            </label>
                            <select name="outlet_id" id="outlet_id" class="form-select <?php $__errorArgs = ['outlet_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">-- Pilih Outlet --</option>
                                <?php $__currentLoopData = $outlets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outlet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($outlet->id); ?>" <?php echo e(old('outlet_id') == $outlet->id ? 'selected' : ''); ?>>
                                    <?php echo e($outlet->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['outlet_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="row mb-4">
                            <div class="col-md-6 mb-3 mb-md-0">
                                <label for="reservation_date" class="form-label fw-bold">
                                    <i class="ri-calendar-line me-1"></i>Tanggal <span class="text-danger">*</span>
                                </label>
                                <input type="date" name="reservation_date" id="reservation_date"
                                       class="form-control <?php $__errorArgs = ['reservation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('reservation_date', date('Y-m-d'))); ?>"
                                       min="<?php echo e(date('Y-m-d')); ?>"
                                       max="<?php echo e(date('Y-m-d', strtotime('+30 days'))); ?>"
                                       required>
                                <small class="text-muted">Reservasi maksimal 30 hari ke depan</small>
                                <?php $__errorArgs = ['reservation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="reservation_time" class="form-label fw-bold">
                                    <i class="ri-time-line me-1"></i>Waktu <span class="text-danger">*</span>
                                </label>
                                <select name="reservation_time" id="reservation_time"
                                        class="form-select <?php $__errorArgs = ['reservation_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">-- Pilih Waktu --</option>
                                    <?php $__currentLoopData = $timeSlots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($slot); ?>" <?php echo e(old('reservation_time') == $slot ? 'selected' : ''); ?>>
                                        <?php echo e($slot); ?> WIB
                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <small class="text-muted">Jam operasional: 10:00 - 22:00</small>
                                <?php $__errorArgs = ['reservation_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="mb-4">
                            <label for="party_size" class="form-label fw-bold">
                                <i class="ri-group-line me-1"></i>Jumlah Orang <span class="text-danger">*</span>
                            </label>
                            <input type="number" name="party_size" id="party_size"
                                   class="form-control <?php $__errorArgs = ['party_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('party_size', 2)); ?>"
                                   min="1" max="20" required>
                            <small class="text-muted">Maksimal 20 orang per reservasi</small>
                            <?php $__errorArgs = ['party_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <hr class="my-4">

                        
                        <?php if(auth()->guard()->guest()): ?>
                        <h5 class="mb-3"><i class="ri-user-line me-2"></i>Informasi Kontak</h5>
                        <div class="alert alert-info">
                            <i class="ri-information-line me-2"></i>
                            <small>Anda tidak perlu login untuk melakukan reservasi. Cukup isi informasi di bawah ini.</small>
                        </div>

                        <div class="mb-3">
                            <label for="guest_name" class="form-label">
                                Nama Lengkap <span class="text-danger">*</span>
                            </label>
                            <input type="text" name="guest_name" id="guest_name"
                                   class="form-control <?php $__errorArgs = ['guest_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('guest_name')); ?>"
                                   placeholder="Nama lengkap Anda" required>
                            <?php $__errorArgs = ['guest_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="guest_email" class="form-label">
                                Email <span class="text-danger">*</span>
                            </label>
                            <input type="email" name="guest_email" id="guest_email"
                                   class="form-control <?php $__errorArgs = ['guest_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('guest_email')); ?>"
                                   placeholder="email@example.com" required>
                            <small class="text-muted">Untuk konfirmasi reservasi</small>
                            <?php $__errorArgs = ['guest_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4">
                            <label for="guest_phone" class="form-label">
                                No. Telepon <span class="text-danger">*</span>
                            </label>
                            <input type="tel" name="guest_phone" id="guest_phone"
                                   class="form-control <?php $__errorArgs = ['guest_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('guest_phone')); ?>"
                                   placeholder="08123456789" required>
                            <small class="text-muted">Untuk konfirmasi dan komunikasi</small>
                            <?php $__errorArgs = ['guest_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <hr class="my-4">
                        <?php endif; ?>

                        <?php if(auth()->guard()->check()): ?>
                        <div class="alert alert-success mb-4">
                            <i class="ri-check-line me-2"></i>
                            Reservasi atas nama: <strong><?php echo e(Auth::user()->name); ?></strong>
                        </div>
                        <?php endif; ?>

                        
                        <div class="mb-4">
                            <label for="special_requests" class="form-label fw-bold">
                                <i class="ri-message-2-line me-1"></i>Permintaan Khusus
                                <small class="text-muted">(Opsional)</small>
                            </label>
                            <textarea name="special_requests" id="special_requests"
                                      class="form-control <?php $__errorArgs = ['special_requests'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                      rows="3"
                                      placeholder="Contoh: Dekat jendela, high chair untuk anak, perayaan ulang tahun, dll."><?php echo e(old('special_requests')); ?></textarea>
                            <?php $__errorArgs = ['special_requests'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="alert alert-warning">
                            <h6 class="alert-heading"><i class="ri-alert-line me-2"></i>Catatan Penting:</h6>
                            <ul class="mb-0 small">
                                <li>Reservasi akan menunggu konfirmasi dari pihak restoran</li>
                                <li>Mohon datang 10 menit sebelum waktu reservasi</li>
                                <li>Reservasi dapat dibatalkan maksimal 2 jam sebelum waktu yang ditentukan</li>
                                <li>Keterlambatan lebih dari 15 menit dapat mengakibatkan pembatalan otomatis</li>
                            </ul>
                        </div>

                        
                        <div class="d-grid gap-2 mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="ri-calendar-check-line me-2"></i>Buat Reservasi
                            </button>
                            <a href="<?php echo e(route('welcome')); ?>" class="btn btn-outline-secondary">
                                <i class="ri-arrow-left-line me-2"></i>Kembali
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            
            <div class="text-center mt-4">
                <p class="text-muted">
                    <i class="ri-question-line me-1"></i>
                    Sudah punya reservasi? <a href="<?php echo e(route('customer.reservations.index')); ?>">Lihat reservasi saya</a>
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-format phone number
    document.getElementById('guest_phone')?.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        e.target.value = value;
    });

    // Form validation
    document.getElementById('reservationForm').addEventListener('submit', function(e) {
        const partySize = document.getElementById('party_size').value;
        if (partySize > 10) {
            if (!confirm('Reservasi untuk lebih dari 10 orang mungkin memerlukan persetujuan khusus. Lanjutkan?')) {
                e.preventDefault();
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.guest-order', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/customer/reservations/create.blade.php ENDPATH**/ ?>