<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="light-style layout-content-navbar" dir="ltr"
    data-theme="theme-default" data-assets-path="<?php echo e(asset('/materialize')); ?>/assets/"
    data-template="vertical-menu-template-no-customizer" data-style="light">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', config('app.name', 'Solusi Kopi')); ?></title>

    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(asset('/materialize')); ?>/assets/img/favicon/favicon.ico" type="image/x-icon" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&amp;display=swap"
        rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/fonts/remixicon/remixicon.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/css/rtl/theme-default.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/css/demo.css" />

    <!-- Plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet"
        href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/flatpickr/flatpickr.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/toastr/toastr.css" />

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <div class="content-wrapper">
                <div class="container-fluid flex-grow-1 container-p-y">
                    <?php echo e($slot); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Core JS -->
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/popper/popper.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/js/bootstrap.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/hammer/hammer.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/js/menu.js"></script>

    <!-- Plugins JS -->
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/moment/moment.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/flatpickr/flatpickr.min.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="<?php echo e(asset('/materialize')); ?>/assets/vendor/libs/toastr/toastr.js"></script>

    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>

    <!-- Main JS -->
    <script src="<?php echo e(asset('/materialize')); ?>/assets/js/main.js"></script>

    <script>
        // Toastr Options (basic initialization)
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };
    </script>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo $__env->yieldPushContent('modals'); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /Users/emnizaar/project-laravel/solusi-kopi/resources/views/components/order-layout.blade.php ENDPATH**/ ?>